<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CompanyAllegroCategoryItems
 *
 * @ORM\Table(name="company_allegro_category_items")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class CompanyAllegroCategoryItem
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $id;

    /**
     * @var integer
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     *
     * @ORM\Column(name="round_id", type="integer")
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="item_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $itemId;

    /**
     * @var integer $quantity
     *
     * @ORM\Column(name="quantity", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $quantity;


    /**
     * @var integer $price
     *
     * @ORM\Column(name="price", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $price;


    /**
     * @var integer
     *
     * @ORM\Column(name="loan_id", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $loanId;


    /**
     * @var integer $depreciation
     *
     * @ORM\Column(name="depreciation", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $depreciation = 0;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="places")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    private $round;


    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="places")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="\Import\ApiBundle\Entity\AllegroCategoryItem",inversedBy="companyItems")
     * @ORM\JoinColumn(name="item_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $item;

    /**
     * @ORM\ManyToOne(targetEntity="CompanyBankServiceOption",inversedBy="companyItems")
     * @ORM\JoinColumn(name="loan_id", referencedColumnName="id")
     */
    private $loan;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyAllegroCategoryItem
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set itemId
     *
     * @param integer $itemId
     * @return CompanyAllegroCategoryItem
     */
    public function setItemId($itemId)
    {
        $this->itemId = $itemId;
    
        return $this;
    }

    /**
     * Get itemId
     *
     * @return integer 
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * Set quantity
     *
     * @param integer $quantity
     * @return CompanyAllegroCategoryItem
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    
        return $this;
    }

    /**
     * Get quantity
     *
     * @return integer 
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyAllegroCategoryItem
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set item
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $item
     * @return CompanyAllegroCategoryItem
     */
    public function setItem(\Import\ApiBundle\Entity\AllegroCategoryItem $item = null)
    {
        $this->item = $item;
    
        return $this;
    }

    /**
     * Get item
     *
     * @return \Import\ApiBundle\Entity\AllegroCategoryItem 
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return CompanyAllegroCategoryItem
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return CompanyAllegroCategoryItem
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set price
     *
     * @param float $price
     * @return CompanyAllegroCategoryItem
     */
    public function setPrice($price)
    {
        $this->price = $price;
    
        return $this;
    }

    /**
     * Get price
     *
     * @return float 
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Set loanId
     *
     * @param integer $loanId
     * @return CompanyAllegroCategoryItem
     */
    public function setLoanId($loanId)
    {
        $this->loanId = $loanId;
    
        return $this;
    }

    /**
     * Get loanId
     *
     * @return integer 
     */
    public function getLoanId()
    {
        return $this->loanId;
    }

    /**
     * Set loan
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $loan
     * @return CompanyAllegroCategoryItem
     */
    public function setLoan(\VM\ApiBundle\Entity\CompanyBankServiceOption $loan = null)
    {
        $this->loan = $loan;
    
        return $this;
    }

    /**
     * Get loan
     *
     * @return \VM\ApiBundle\Entity\CompanyBankServiceOption 
     */
    public function getLoan()
    {
        return $this->loan;
    }

    /**
     * Set depreciation
     *
     * @param integer $depreciation
     * @return CompanyAllegroCategoryItem
     */
    public function setDepreciation($depreciation)
    {
        $this->depreciation = $depreciation;
    
        return $this;
    }

    /**
     * Get depreciation
     *
     * @return integer 
     */
    public function getDepreciation()
    {
        return $this->depreciation;
    }
}